<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:template name="total-numbers">
		<xsl:param name="list" />
		<xsl:variable name="wlist" select="concat(normalize-space($list), ' ')" />
		<xsl:choose>
			<xsl:when test="$wlist!=' '">
				<xsl:variable name="first" select="substring-before($wlist, ' ')" />
				<xsl:variable name="rest" select="substring-after($wlist, ' ')"/>
				<xsl:variable name="total">
					<xsl:call-template name="total-numbers">
						<xsl:with-param name="list" select="$rest"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="number($first) + number($total)"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="/">
		<xsl:call-template name="total-numbers">
			<xsl:with-param name="list" select="."/>
		</xsl:call-template>
	</xsl:template>
</xsl:stylesheet>